
library(memisc)


library(mclogit)


load("model-cathprot-prayer-soclife-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_soclife <- mtable(model_soclife,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Social Lifestyle" = c("Squared" = "sociallifestyle.sq",                        
                                                "Linear"  = "sociallifestyle",                           
                                                "$\\times$ Protestant"     = "sociallifestyle:cathprotProtestant",
                                                "$\\times$ prays rarely"   = "sociallifestyle:prayRarely",
                                                "$\\times$ prays monthly"  = "sociallifestyle:prayMonthly",
                                                "$\\times$ prays weekly"   = "sociallifestyle:prayWeekly",
                                                "$\\times$ prays daily"    = "sociallifestyle:prayDaily",
                                                "$\\times$ Protestant $\\times$ prays rarely"   = "sociallifestyle:cathprotProtestant:prayRarely",
                                                "$\\times$ Protestant $\\times$ prays monthly"  = "sociallifestyle:cathprotProtestant:prayMonthly",
                                                "$\\times$ Protestant $\\times$ prays weekly"   = "sociallifestyle:cathprotProtestant:prayWeekly",
                                                "$\\times$ Protestant $\\times$ prays daily"    = "sociallifestyle:cathprotProtestant:prayDaily",
                                                "$\\times$ self-employed"  = "sociallifestyle:oesch8Self-employed",       
                                                "$\\times$ technical"      = "sociallifestyle:oesch8Technical",           
                                                "$\\times$ management"     = "sociallifestyle:oesch8Management",          
                                                "$\\times$ clerks"         = "sociallifestyle:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "sociallifestyle:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "sociallifestyle:oesch8Service worker",      
                                                "$\\times$ primary sector" = "sociallifestyle:oesch8Primary sector",      
                                                "$\\times$ denominational balance"       = "sociallifestyle:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "sociallifestyle:Denom_Het",
                                                "$\\times$ time" = "sociallifestyle:time", 
                                                "$\\times$ Protestant     $\\times$ time"  = "sociallifestyle:cathprotProtestant:time",
                                                "$\\times$ prays rarely   $\\times$ time"  = "sociallifestyle:prayRarely:time",
                                                "$\\times$ prays monthly  $\\times$ time"  = "sociallifestyle:prayMonthly:time",
                                                "$\\times$ prays weekly   $\\times$ time"  = "sociallifestyle:prayWeekly:time",
                                                "$\\times$ prays daily    $\\times$ time"  = "sociallifestyle:prayDaily:time",
                                                "$\\times$ Protestant     $\\times$ prays rarely   $\\times$ time"  = "sociallifestyle:prayRarely:time",
                                                "$\\times$ Protestant     $\\times$ prays monthly  $\\times$ time"  = "sociallifestyle:prayMonthly:time",
                                                "$\\times$ Protestant     $\\times$ prays weekly   $\\times$ time"  = "sociallifestyle:prayWeekly:time",
                                                "$\\times$ Protestant     $\\times$ prays daily    $\\times$ time"  = "sociallifestyle:prayDaily:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "sociallifestyle:time:oesch8Self-employed",  
                                                "$\\times$ technical      $\\times$ time"  = "sociallifestyle:time:oesch8Technical",      
                                                "$\\times$ management     $\\times$ time"  = "sociallifestyle:time:oesch8Management",     
                                                "$\\times$ clerks         $\\times$ time"  = "sociallifestyle:time:oesch8Clerks",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "sociallifestyle:time:oesch8Socio-cultural", 
                                                "$\\times$ service worker $\\times$ time"  = "sociallifestyle:time:oesch8Service worker", 
                                                "$\\times$ primary sector $\\times$ time"  = "sociallifestyle:time:oesch8Primary sector"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ Protestant"     = "cathprotProtestant:immigration",
                                              "$\\times$ prays rarely"   = "prayRarely:immigration",
                                              "$\\times$ prays monthly"  = "prayMonthly:immigration",
                                              "$\\times$ prays weekly"   = "prayWeekly:immigration",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",                
                                              "$\\times$ technical"      = "oesch8Technical:immigration",                    
                                              "$\\times$ management"     = "oesch8Management:immigration",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",               
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",                 
                                              "$\\times$ time" = "time:immigration",          
                                              "$\\times$ Protestant     $\\times$ time" = "cathprotProtestant:time:immigration",
                                              "$\\times$ prays rarely   $\\times$ time" = "prayRarely:time:immigration",
                                              "$\\times$ prays monthly  $\\times$ time" = "prayMonthly:time:immigration",
                                              "$\\times$ prays weekly   $\\times$ time" = "prayWeekly:time:immigration",
                                              "$\\times$ prays daily    $\\times$ time" = "prayDaily:time:immigration",
                                              "$\\times$ self-employed  $\\times$ time" = "time:oesch8Self-employed:immigration",           
                                              "$\\times$ technical      $\\times$ time" = "time:oesch8Technical:immigration",               
                                              "$\\times$ management     $\\times$ time" = "time:oesch8Management:immigration",              
                                              "$\\times$ clerks         $\\times$ time" = "time:oesch8Clerks:immigration",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "time:oesch8Socio-cultural:immigration",          
                                              "$\\times$ service worker $\\times$ time" = "time:oesch8Service worker:immigration",          
                                              "$\\times$ primary sector $\\times$ time" = "time:oesch8Primary sector:immigration"),   
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",                                 
                                              "Linear"  = "lrecon",                                         
                                              "$\\times$ Protestant"     = "cathprotProtestant:lrecon",
                                              "$\\times$ prays rarely"   = "prayRarely:lrecon",
                                              "$\\times$ prays monthly"  = "prayMonthly:lrecon",
                                              "$\\times$ prays weekly"   = "prayWeekly:lrecon",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",                    
                                              "$\\times$ management"     = "oesch8Management:lrecon",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",               
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                 
                                              "$\\times$ time" = "time:lrecon",          
                                              "$\\times$ Protestant     $\\times$ time" = "cathprotProtestant:time:lrecon",
                                              "$\\times$ prays rarely   $\\times$ time" = "prayRarely:time:lrecon",
                                              "$\\times$ prays monthly  $\\times$ time" = "prayMonthly:time:lrecon",
                                              "$\\times$ prays weekly   $\\times$ time" = "prayWeekly:time:lrecon",
                                              "$\\times$ prays daily    $\\times$ time" = "prayDaily:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time" = "time:oesch8Self-employed:lrecon",           
                                              "$\\times$ technical      $\\times$ time" = "time:oesch8Technical:lrecon",               
                                              "$\\times$ management     $\\times$ time" = "time:oesch8Management:lrecon",              
                                              "$\\times$ clerks         $\\times$ time" = "time:oesch8Clerks:lrecon",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "time:oesch8Socio-cultural:lrecon",          
                                              "$\\times$ service worker $\\times$ time" = "time:oesch8Service worker:lrecon",          
                                              "$\\times$ primary sector $\\times$ time" = "time:oesch8Primary sector:lrecon")
                        )))


m_soclife


m_soclife |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="cathprot-context-soclife/mtable-cathprot-prayer-context-soclife.tex")




